#include "StdAfx.h"
#include "common.h"
#include ".\error.h"
#include ".\tree.h"
#include ".\asmutils.h"
#include ".\typechecking.h"

CTypeChecking::CTypeChecking(void)
{
}

CTypeChecking::~CTypeChecking(void)
{
}

void CTypeChecking::Process(SCRIPT* theScript)
{
	if (theScript->toplevels)
		processTOPLEVEL(theScript->toplevels);
}

void CTypeChecking::processTOPLEVEL(TOPLEVEL* toplevel)
{
	if (toplevel->function)
		processFUNCTION(toplevel->function);

	if (toplevel->next)
		processTOPLEVEL(toplevel->next);
}

void CTypeChecking::processFUNCTION(FUNCTION* function)
{
	switch (function->kind)
	{
	case localT:
		if (function->statements)
			processSTATEMENT(function->statements);
		break;
	default:
		break;
	}
}

void CTypeChecking::processFORINIT(FORINIT* forinit)
{
	switch (forinit->kind)
	{
	case expressionforinitT:
		processEXPRESSION(forinit->val.expressionF,&(forinit->val.expressionF->typeError));
		//pokud se vrati ve strukture typeError zkoumaneho vyrazu v promenne isError true, znamena to, ze ve vyrazu
		//se vyskytuje volani funkce, ktera nevraci hodnotu, a to je chyba, kterou nemuzeme tolerovat
		if (forinit->val.expressionF->typeError.isError)
			theLog.ReportError(forinit->val.expressionF->line_number," You cannot use function <b>%s</b> that does not return value inside for initialization!<br>",forinit->val.expressionF->typeError.msgError);
		break;
	case declarationforinitT:
		break;
	}

	if (forinit->next)
		processFORINIT(forinit->next);
}

void CTypeChecking::processDECLARATION(DECLARATION* declaration)
{
	switch (declaration->kind)
	{
	case variableT:
		processEXPRESSION(declaration->val.variableD.initialization,&(declaration->val.variableD.initialization->typeError));
		if (declaration->val.variableD.initialization->typeError.isError)
			theLog.ReportError(declaration->val.variableD.initialization->line_number,"You cannot use function <b>%s</b> that does not return value inside variable initialization!<br>",declaration->val.variableD.initialization->typeError.msgError);
		break;
	case simplevarT:
		processEXPRESSION(declaration->val.simplevarD.initialization,&(declaration->val.simplevarD.initialization->typeError));
		if (declaration->val.simplevarD.initialization->typeError.isError)
			theLog.ReportError(declaration->val.simplevarD.initialization->line_number,"You cannot use function <b>%s</b> that does not return value inside variable initialization!<br>",declaration->val.simplevarD.initialization->typeError.msgError);
		break;
	}

	if (declaration->next)
		processDECLARATION(declaration->next);
}

void CTypeChecking::processSTATEMENT(STATEMENT* statement)
{
	switch (statement->kind)
	{
	case skipT:
		break;
	case returnT:
		processEXPRESSION(statement->val.returnS.expression,&(statement->val.returnS.expression->typeError));
		if (statement->val.returnS.expression->typeError.isError)
			theLog.ReportError(statement->val.returnS.expression->line_number," You cannot use function <b>%s</b> that does not return value inside return statement!<br>",statement->val.returnS.expression->typeError.msgError);
		break;
	case scopeT:
		processSTATEMENT(statement->val.scopeS.statement);
		break;
	case declstmT:
		processDECLARATION(statement->val.declaration);
		break;
	case expT:
		processEXPRESSION(statement->val.expression,&(statement->val.expression->typeError));
		//pokud se nejedna o proste volani funkce
		if (statement->val.expression->kind != callT)
		{
			if (statement->val.expression->typeError.isError)
				theLog.ReportError(statement->val.expression->line_number," You cannot use function <b>%s</b> that does not return value inside expression!<br>",statement->val.expression->typeError.msgError);
		}
		break;
	case ifT:
		processEXPRESSION(statement->val.ifS.condition,&(statement->val.ifS.condition->typeError));
		if (statement->val.ifS.condition->typeError.isError)
		{
			theLog.ReportError(statement->val.ifS.condition->line_number," You cannot use function <b>%s</b> that does not return value inside if condition!<br>",statement->val.ifS.condition->typeError.msgError);
			break;
		}
		processSTATEMENT(statement->val.ifS.body);
		break;
	case ifelseT:
		processEXPRESSION(statement->val.ifelseS.condition,&(statement->val.ifelseS.condition->typeError));
		if (statement->val.ifelseS.condition->typeError.isError)
		{
			theLog.ReportError(statement->val.ifelseS.condition->line_number," You cannot use function <b>%s</b> that does not return value inside if-else condition!<br>",statement->val.ifelseS.condition->typeError.msgError);
			break;
		}
		processSTATEMENT(statement->val.ifelseS.ifbody);
		processSTATEMENT(statement->val.ifelseS.elsebody);
		break;
	case whileT:
		processEXPRESSION(statement->val.whileS.condition,&(statement->val.whileS.condition->typeError));
		if (statement->val.whileS.condition->typeError.isError)
		{
			theLog.ReportError(statement->val.whileS.condition->line_number," You cannot use function <b>%s</b> that does not return value inside while condition!<br>",statement->val.whileS.condition->typeError.msgError);
			break;
		}
		processSTATEMENT(statement->val.whileS.body);
		break;
	case forT:
		processFORINIT(statement->val.forS.inits);
		processEXPRESSION(statement->val.forS.condition,&(statement->val.forS.condition->typeError));
		if (statement->val.forS.condition->typeError.isError)
		{
			theLog.ReportError(statement->val.forS.condition->line_number," You cannot use function <b>%s</b> that does not return value inside for condition!<br>",statement->val.forS.condition->typeError.msgError);
			break;
		}
		processEXPRESSION(statement->val.forS.updates,&(statement->val.forS.updates->typeError));
		if (statement->val.forS.updates->typeError.isError)
		{
			theLog.ReportError(statement->val.forS.updates->line_number," You cannot use function <b>%s</b> that does not return value inside for update!<br>",statement->val.forS.updates->typeError.msgError);
			break;
		}
		processSTATEMENT(statement->val.forS.body);
		break;
	case sequenceT:
		processSTATEMENT(statement->val.sequenceS.firts);
		processSTATEMENT(statement->val.sequenceS.second);
		break;	
	}
}

void CTypeChecking::processEXPRESSION(EXPRESSION* expression,TYPE_ERROR* typeError)
{
	if (expression == NULL)
		return;

	switch (expression->kind)
	{
	case intconstT:
		break;
	case stringconstT:
		break;
	case uminusT:
		processEXPRESSION(expression->val.uminusE,typeError);
		break;
	case notT:
		processEXPRESSION(expression->val.notE.expression,typeError);
		break;
	case lvalueT:
		break;
	case assignmentT:
		processEXPRESSION(expression->val.assignmentE.right,typeError);
		break;
	case equalsT:
		processEXPRESSION(expression->val.equalsE.left,typeError);
		processEXPRESSION(expression->val.equalsE.right,typeError);
		break;
	case nequalsT:
		processEXPRESSION(expression->val.nequalsE.left,typeError);
		processEXPRESSION(expression->val.nequalsE.right,typeError);
		break;
	case lessT:
		processEXPRESSION(expression->val.lessE.left,typeError);
		processEXPRESSION(expression->val.lessE.right,typeError);
		break;
	case lequalsT:
		processEXPRESSION(expression->val.lequalsE.left,typeError);
		processEXPRESSION(expression->val.lequalsE.right,typeError);
		break;
	case gequalsT:
		processEXPRESSION(expression->val.gequalsE.left,typeError);
		processEXPRESSION(expression->val.gequalsE.right,typeError);
		break;
	case plusT:
		processEXPRESSION(expression->val.plusE.left,typeError);
		processEXPRESSION(expression->val.plusE.right,typeError);
		break;
	case minusT:
		processEXPRESSION(expression->val.minusE.left,typeError);
		processEXPRESSION(expression->val.minusE.right,typeError);
		break;
	case mulT:
		processEXPRESSION(expression->val.mulE.left,typeError);
		processEXPRESSION(expression->val.mulE.right,typeError);
		break;
	case divT:
		processEXPRESSION(expression->val.divE.left,typeError);
		processEXPRESSION(expression->val.divE.right,typeError);
		break;
	case modT:
		processEXPRESSION(expression->val.modE.left,typeError);
		processEXPRESSION(expression->val.modE.right,typeError);
		break;
	case andT:
		processEXPRESSION(expression->val.andE.left,typeError);
		processEXPRESSION(expression->val.andE.right,typeError);
		break;
	case orT:
		processEXPRESSION(expression->val.orE.left,typeError);
		processEXPRESSION(expression->val.orE.right,typeError);
		break;
	case bitorT:
		processEXPRESSION(expression->val.bitorE.left,typeError);
		processEXPRESSION(expression->val.bitorE.right,typeError);
		break;
	case bitandT:
		processEXPRESSION(expression->val.bitandE.left,typeError);
		processEXPRESSION(expression->val.bitandE.right,typeError);
		break;
	case plusassignT:
		processEXPRESSION(expression->val.plusassignE.right,typeError);
		break;
	case minusassignT:
		processEXPRESSION(expression->val.minusassignE.right,typeError);
		break;
	case mulassignT:
		processEXPRESSION(expression->val.mulassignE.right,typeError);
		break;
	case divassignT:
		processEXPRESSION(expression->val.divassignE.right,typeError);
		break;
	case modassignT:
		processEXPRESSION(expression->val.modassignE.right,typeError);
		break;
	case orassignT:
		processEXPRESSION(expression->val.orassignE.right,typeError);
		break;
	case andassignT:
		processEXPRESSION(expression->val.andassignE.right,typeError);
		break;
	case shlassignT:
		processEXPRESSION(expression->val.shlassignE.right,typeError);
		break;
	case shrassignT:
		processEXPRESSION(expression->val.shrassignE.right,typeError);
		break;
	case shlT:
		processEXPRESSION(expression->val.shlE.left,typeError);
		processEXPRESSION(expression->val.shlE.right,typeError);
		break;
	case shrT:
		processEXPRESSION(expression->val.shrE.left,typeError);
		processEXPRESSION(expression->val.shrE.right,typeError);
		break;
	case prefincT:
	case postincT:
	case prefdecT:
	case postdecT:
		break;
	case callT:
		if (expression->val.callE.arguments != NULL)
		{
			//zkontroluje parametry funkce
			processEXPRESSION(expression->val.callE.arguments,typeError);
		}
		//pokud funkce nevraci hodnotu, nastav chybu volani funkce, ktera nevraci hodnotu
		if (expression->val.callE.symbol->val.functionS->returns_value == false)
		{
			typeError->isError = true;
			typeError->msgError = expression->val.callE.name;
		}
		else
		{
			typeError->isError = false;
			typeError->msgError = NULL;
		}

		break;
	}

	if (expression->next != NULL)
		processEXPRESSION(expression->next,typeError);
}